#ifndef GST_CU_QUERY_FILTER_HPP
#define GST_CU_QUERY_FILTER_HPP

#include <buildspec.h>

#include "Client/ClientUtils/AreaLimiter.hpp"

#include <boost/optional.hpp>

#include <cstdint>
#include <string>
#include <vector>

namespace GST
{
namespace ClientUtils
{
struct GST_API_EXPORT NewQueryFilter
{
	std::string name;
	int32_t ownerId;
	boost::optional<std::string> attributeFilter;
	boost::optional<std::string> fcFilter;
	boost::optional<AreaLimiter> spatialFilter;
};

struct GST_API_EXPORT QueryFilter
{
	int64_t id;
	std::string name;
	int32_t ownerId;
	std::string createdAt;
	std::string updatedAt;
	boost::optional<std::string> attributeFilter;
	boost::optional<std::string> fcFilter;
	boost::optional<AreaLimiter> spatialFilter;
};

struct GST_API_EXPORT QueryFilterSummary
{
	int64_t id;
	std::string name;
	int32_t ownerId;
	std::string createdAt;
	std::string updatedAt;
	bool hasAttributeFilter;
	bool hasFcFilter;
	bool hasSpatialFilter;
};
typedef std::vector<QueryFilterSummary> QueryFilterSummaryList;
} // namespace ClientUtils
} // namespace GST

#endif // GST_CU_QUERY_FILTER_HPP
